/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.admin.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.broadleafcommerce.presentation.dialect.BroadleafProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.BroadleafThymeleaf3MessageResolver;
import org.broadleafcommerce.presentation.thymeleaf3.BroadleafThymeleaf3TemplateEngine;
import org.broadleafcommerce.presentation.thymeleaf3.BroadleafThymeleafViewResolver;
import org.broadleafcommerce.presentation.thymeleaf3.admin.config.Thymeleaf3AdminTemplateConfig;
import org.broadleafcommerce.presentation.thymeleaf3.config.AbstractThymeleaf3DialectConfig;
import org.broadleafcommerce.presentation.thymeleaf3.config.AbstractThymeleaf3EngineConfig;
import org.broadleafcommerce.presentation.thymeleaf3.config.Thymeleaf3CommonConfig;
import org.broadleafcommerce.presentation.thymeleaf3.dialect.BroadleafThymeleaf3AdminDialect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class Thymeleaf3AdminConfig
extends Thymeleaf3CommonConfig {
    @Bean
    public IMessageResolver blAdminMessageResolver() {
        BroadleafThymeleaf3MessageResolver resolver = new BroadleafThymeleaf3MessageResolver();
        resolver.setOrder(100);
        return resolver;
    }

    @Configuration
    static class Thymeleaf3AdminViewConfig {
        protected ISpringTemplateEngine templateEngine;
        protected Environment environment;

        public Thymeleaf3AdminViewConfig(ISpringTemplateEngine templateEngine, Environment environment) {
            this.templateEngine = templateEngine;
            this.environment = environment;
        }

        @Bean(name={"blAdminThymeleafViewResolver", "thymeleafViewResolver"})
        public BroadleafThymeleafViewResolver blAdminThymeleafViewResolver() {
            BroadleafThymeleafViewResolver view = new BroadleafThymeleafViewResolver();
            view.setTemplateEngine(this.templateEngine);
            view.setOrder(1);
            view.setCache((Boolean)this.environment.getProperty("thymeleaf.view.resolver.cache", Boolean.class, (Object)true));
            view.setCharacterEncoding("UTF-8");
            view.setFullPageLayout("layout/fullPageLayout");
            HashMap<String, String> layoutMap = new HashMap<String, String>();
            layoutMap.put("login/", "layout/loginLayout");
            layoutMap.put("views/", "NONE");
            layoutMap.put("modules/modalContainer", "NONE");
            view.setLayoutMap(layoutMap);
            return view;
        }
    }

    @Configuration
    static class Thymeleaf3AdminEngineConfig
    extends AbstractThymeleaf3EngineConfig {
        protected Set<IMessageResolver> messageResolvers;

        public Thymeleaf3AdminEngineConfig(Set<IMessageResolver> messageResolvers) {
            this.messageResolvers = messageResolvers;
        }

        @Bean
        public Set<ITemplateResolver> blAdminWebTemplateResolvers() {
            return this.configUtil.getWebResolvers(this.blcTemplateResolvers);
        }

        @Bean
        @Primary
        public BroadleafThymeleaf3TemplateEngine blAdminWebTemplateEngine() {
            BroadleafThymeleaf3TemplateEngine engine = new BroadleafThymeleaf3TemplateEngine();
            engine.setMessageResolvers(this.messageResolvers);
            LinkedHashSet<ITemplateResolver> allResolvers = new LinkedHashSet<ITemplateResolver>();
            allResolvers.addAll(this.iTemplateResolvers);
            allResolvers.addAll(this.blAdminWebTemplateResolvers());
            engine.setTemplateResolvers(allResolvers);
            engine.setDialects(this.dialects);
            return engine;
        }

        @Configuration
        protected static class Thymeleaf3AdminTemplateResolverConfig
        extends Thymeleaf3AdminTemplateConfig {
            protected Thymeleaf3AdminTemplateResolverConfig() {
            }
        }
    }

    @Configuration
    static class Thymeleaf3AdminDialectConfig
    extends AbstractThymeleaf3DialectConfig {
        Thymeleaf3AdminDialectConfig() {
        }

        @Bean
        public BroadleafThymeleaf3AdminDialect blAdminDialect() {
            BroadleafThymeleaf3AdminDialect dialect = new BroadleafThymeleaf3AdminDialect();
            LinkedHashSet<IProcessor> allProcessors = new LinkedHashSet<IProcessor>();
            allProcessors.addAll(this.iProcessors);
            allProcessors.addAll(this.blAdminDialectProcessors());
            dialect.setProcessors(allProcessors);
            return dialect;
        }

        @Override
        @Bean
        public Set<IProcessor> blDialectProcessors() {
            ArrayList<BroadleafProcessor> commonProcessors = new ArrayList<BroadleafProcessor>();
            for (BroadleafProcessor processor : this.blcProcessors) {
                if (!"blc".equals(processor.getPrefix())) continue;
                commonProcessors.add(processor);
            }
            return this.configUtil.getDialectProcessors(commonProcessors);
        }

        @Bean
        public Set<IProcessor> blAdminDialectProcessors() {
            ArrayList<BroadleafProcessor> adminProcessors = new ArrayList<BroadleafProcessor>();
            for (BroadleafProcessor processor : this.blcProcessors) {
                if (!"blc_admin".equals(processor.getPrefix())) continue;
                adminProcessors.add(processor);
            }
            return this.configUtil.getDialectProcessors(adminProcessors);
        }

        @Bean
        public Set<IDialect> blAdminDialects() {
            LinkedHashSet<IDialect> dialects = new LinkedHashSet<IDialect>();
            dialects.add((IDialect)this.thymeleafSpringStandardDialect());
            dialects.add((IDialect)this.blAdminDialect());
            dialects.add((IDialect)this.blDialect());
            return dialects;
        }
    }
}

