/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.BroadleafTemplateViewResolverExtensionHandler;
import org.broadleafcommerce.common.web.BroadleafTemplateViewResolverExtensionManager;
import org.broadleafcommerce.common.web.controller.BroadleafControllerUtility;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.thymeleaf.spring5.view.AbstractThymeleafView;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;

public class BroadleafThymeleafViewResolver
extends ThymeleafViewResolver {
    private static final Log LOG = LogFactory.getLog(BroadleafThymeleafViewResolver.class);
    @Resource(name="blBroadleafTemplateViewResolverExtensionManager")
    protected BroadleafTemplateViewResolverExtensionManager extensionManager;
    public static final String EXTENSION_TEMPLATE_ATTR_NAME = "extensionTemplateAttr";
    public static final String AJAX_REDIRECT_URL_PREFIX = "ajaxredirect:";
    protected Map<String, String> layoutMap = new HashMap<String, String>();
    protected String fullPageLayout = "layout/fullPageLayout";
    protected String iframeLayout = "layout/iframeLayout";

    protected boolean useThymeleafLayoutDialect() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"thymeleaf.useLayoutDialect");
    }

    protected boolean canHandle(String viewName) {
        String[] viewNamesToBeProcessed = this.getViewNames();
        String[] viewNamesNotToBeProcessed = this.getExcludedViewNames();
        return !(viewNamesToBeProcessed != null && !PatternMatchUtils.simpleMatch((String[])viewNamesToBeProcessed, (String)viewName) || viewNamesNotToBeProcessed != null && PatternMatchUtils.simpleMatch((String[])viewNamesNotToBeProcessed, (String)viewName));
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        ExtensionResultHolder erh = new ExtensionResultHolder();
        ((BroadleafTemplateViewResolverExtensionHandler)this.extensionManager.getProxy()).overrideView(erh, viewName, this.isAjaxRequest());
        String viewOverride = (String)erh.getResult();
        if (viewOverride != null) {
            viewName = viewOverride;
        }
        return super.resolveViewName(viewName, locale);
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        if (!this.canHandle(viewName)) {
            LOG.trace((Object)("[THYMELEAF] View {" + viewName + "} cannot be handled by ThymeleafViewResolver. Passing on to the next resolver in the chain"));
            return null;
        }
        if (viewName.startsWith(AJAX_REDIRECT_URL_PREFIX)) {
            LOG.trace((Object)("[THYMELEAF] View {" + viewName + "} is an ajax redirect, and will be handled directly by BroadleafThymeleafViewResolver"));
            String redirectUrl = viewName.substring(AJAX_REDIRECT_URL_PREFIX.length());
            return this.loadAjaxRedirectView(redirectUrl, locale);
        }
        return super.createView(viewName, locale);
    }

    protected View loadAjaxRedirectView(String redirectUrl, Locale locale) throws Exception {
        if (this.isAjaxRequest()) {
            this.initializeAjaxRedirectFlashmap(redirectUrl);
            String viewName = "utility/blcRedirect";
            this.addStaticVariable("blc_redirect", redirectUrl);
            return super.loadView(viewName, locale);
        }
        return new RedirectView(redirectUrl, false, this.isRedirectHttp10Compatible());
    }

    protected void initializeAjaxRedirectFlashmap(String redirectUrl) {
        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        HttpServletRequest req = brc == null ? null : brc.getRequest();
        HttpServletResponse res = brc == null ? null : brc.getResponse();
        FlashMap flashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)req);
        if (!CollectionUtils.isEmpty((Map)flashMap) && req != null && res != null) {
            UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)redirectUrl).build();
            flashMap.setTargetRequestPath(uriComponents.getPath());
            flashMap.addTargetRequestParams(uriComponents.getQueryParams());
            FlashMapManager flashMapManager = RequestContextUtils.getFlashMapManager((HttpServletRequest)req);
            if (flashMapManager == null) {
                throw new IllegalStateException("FlashMapManager not found despite output FlashMap having been set");
            }
            flashMapManager.saveOutputFlashMap(flashMap, req, res);
        }
    }

    protected View loadView(String originalViewName, Locale locale) throws Exception {
        String viewName = originalViewName;
        if (!this.isAjaxRequest() && !this.useThymeleafLayoutDialect()) {
            String longestPrefix = "";
            for (Map.Entry<String, String> entry : this.layoutMap.entrySet()) {
                String viewPrefix = entry.getKey();
                String viewLayout = entry.getValue();
                if (viewPrefix.length() <= longestPrefix.length() || !originalViewName.startsWith(viewPrefix)) continue;
                longestPrefix = viewPrefix;
                if ("NONE".equals(viewLayout)) continue;
                viewName = viewLayout;
            }
            if (longestPrefix.equals("")) {
                viewName = this.getFullPageLayout();
            }
        }
        AbstractThymeleafView view = null;
        boolean ajaxRequest = this.isAjaxRequest();
        ExtensionResultHolder erh = new ExtensionResultHolder();
        ((BroadleafTemplateViewResolverExtensionHandler)this.extensionManager.getProxy()).provideTemplateWrapper(erh, originalViewName, ajaxRequest);
        String templateWrapper = (String)erh.getResult();
        if (templateWrapper != null && ajaxRequest) {
            view = (AbstractThymeleafView)super.loadView(templateWrapper, locale);
            view.addStaticVariable("wrappedTemplate", (Object)viewName);
        } else {
            view = (AbstractThymeleafView)super.loadView(viewName, locale);
        }
        if (!ajaxRequest) {
            view.addStaticVariable("templateName", (Object)originalViewName);
        }
        return view;
    }

    protected Object getCacheKey(String viewName, Locale locale) {
        String cacheKey = viewName + "_" + locale + "_" + this.isAjaxRequest();
        ExtensionResultHolder erh = new ExtensionResultHolder();
        ((BroadleafTemplateViewResolverExtensionHandler)this.extensionManager.getProxy()).appendCacheKey(erh, viewName, this.isAjaxRequest());
        String addlCacheKey = (String)erh.getResult();
        if (addlCacheKey != null) {
            cacheKey = cacheKey + "_" + addlCacheKey;
        }
        return cacheKey;
    }

    protected boolean isIFrameRequest() {
        WebRequest request = this.getCurrentRequest();
        String iFrameParameter = request.getParameter("blcIFrame");
        return iFrameParameter != null && "true".equals(iFrameParameter);
    }

    protected boolean isAjaxRequest() {
        WebRequest request = this.getCurrentRequest();
        if (request == null) {
            return false;
        }
        return BroadleafControllerUtility.isAjaxRequest((WebRequest)request);
    }

    protected WebRequest getCurrentRequest() {
        WebRequest brcRequest;
        WebRequest request = null;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null && (brcRequest = BroadleafRequestContext.getBroadleafRequestContext().getWebRequest()) != null) {
            request = brcRequest;
        }
        if (request == null) {
            try {
                HttpServletRequest servletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                request = new ServletWebRequest(servletRequest);
            }
            catch (ClassCastException e) {
                LOG.warn((Object)"Unable to cast to ServletRequestAttributes and the request in BroadleafRequestContext was not set. This may introduce incorrect AJAX behavior.");
            }
        }
        return request;
    }

    public Map<String, String> getLayoutMap() {
        return this.layoutMap;
    }

    public void setLayoutMap(Map<String, String> layoutMap) {
        this.layoutMap = layoutMap;
    }

    public String getFullPageLayout() {
        return this.fullPageLayout;
    }

    public void setFullPageLayout(String fullPageLayout) {
        this.fullPageLayout = fullPageLayout;
    }

    public String getIframeLayout() {
        return this.iframeLayout;
    }

    public void setIframeLayout(String iframeLayout) {
        this.iframeLayout = iframeLayout;
    }
}

