/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3;

import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.site.domain.Theme;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.resource.BroadleafContextUtil;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.Validate;

public class BroadleafThymeleaf3ThemeAwareTemplateResolver
extends SpringResourceTemplateResolver {
    @Resource(name="blBroadleafContextUtil")
    protected BroadleafContextUtil blcContextUtil;
    protected String templateFolder = "";

    public BroadleafThymeleaf3ThemeAwareTemplateResolver() {
        this.setCheckExistence(true);
    }

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        String actualPath;
        this.blcContextUtil.establishThinRequestContextWithoutSandBox();
        String themePath = this.getThemePath();
        Validate.notNull((Object)template, (String)"Template name cannot be null");
        String prefix = this.getPrefix();
        String themeAwareResourceName = resourceName;
        String string = actualPath = this.templateFolder == null ? "" : this.templateFolder;
        if (themePath != null && !themePath.trim().equals("")) {
            actualPath = themePath + "/" + actualPath;
        }
        themeAwareResourceName = prefix != null && !prefix.trim().equals("") ? StringUtils.replaceOnce((String)resourceName, (String)prefix, (String)(prefix + actualPath)) : resourceName + actualPath;
        return super.computeTemplateResource(configuration, ownerTemplate, template, themeAwareResourceName, characterEncoding, templateResolutionAttributes);
    }

    protected String getThemePath() {
        Theme theme = BroadleafRequestContext.getBroadleafRequestContext().getTheme();
        return theme == null ? null : theme.getPath();
    }

    public String getTemplateFolder() {
        return this.templateFolder;
    }

    public void setTemplateFolder(String templateFolder) {
        this.templateFolder = templateFolder;
    }
}

