/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3;

import java.util.Locale;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.i18n.service.TranslationService;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.util.Validate;

public class BroadleafThymeleaf3MessageResolver
extends AbstractMessageResolver {
    protected static final Log LOG = LogFactory.getLog(BroadleafThymeleaf3MessageResolver.class);
    protected static final String I18N_VALUE_KEY = "translate";
    @Resource(name="blTranslationService")
    protected TranslationService translationService;

    public String resolveMessage(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        Validate.notNull((Object)context, (String)"args cannot be null");
        Validate.notNull((Object)context.getLocale(), (String)"Locale in context cannot be null");
        Validate.notNull((Object)key, (String)"Message key cannot be null");
        if (I18N_VALUE_KEY.equals(key)) {
            String resolvedMessage;
            Object entity = messageParameters[0];
            String property = (String)messageParameters[1];
            Locale locale = context.getLocale();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("Attempting to resolve translated value for object %s, property %s, locale %s", entity, property, locale));
            }
            if (StringUtils.isNotBlank((CharSequence)(resolvedMessage = this.translationService.getTranslatedValue(entity, property, locale)))) {
                return resolvedMessage;
            }
        }
        return null;
    }

    public String createAbsentMessageRepresentation(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        return null;
    }
}

